// PemWinDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PemWin.h"
#include "PemWinDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPemWinDlg dialog

CPemWinDlg::CPemWinDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPemWinDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPemWinDlg)
	m_1v5current = 0.0;
	m_1v5voltage = 0.0;
	m_3v3current = 0.0;
	m_3v3voltage = 0.0;
	m_pwrsts = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

     Pin42_flag=true;
	 Pin44_flag=true;
	 Pin46_flag=true;
}

void CPemWinDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPemWinDlg)
	DDX_Control(pDX, IDC_ED_46_Value, m_ED_46_Value);
	DDX_Control(pDX, IDC_ED_44_Value, m_ED_44_Value);
	DDX_Control(pDX, IDC_ED_42_Value, m_ED_42_Value);
	DDX_Control(pDX, IDC_ED_Pin46_Mode, m_ED_46_Mode);
	DDX_Control(pDX, IDC_ED_Pin44_Mode, m_ED_44_Mode);
	DDX_Control(pDX, IDC_ED_Pin42_Mode, m_ED_42_Mode);
	DDX_Control(pDX, IDC_BT_Pin46_output, m_Pin46_output);
	DDX_Control(pDX, IDC_BT_Pin44_output, m_Pin44_output);
	DDX_Control(pDX, IDC_BT_Pin42_output, m_Pin42_output);
	DDX_Text(pDX, IDC_1V5CURRENT, m_1v5current);
	DDX_Text(pDX, IDC_1V5VOLTAGE, m_1v5voltage);
	DDX_Text(pDX, IDC_3V3CURRENT, m_3v3current);
	DDX_Text(pDX, IDC_3V3VOLTAGE, m_3v3voltage);
	DDX_Text(pDX, IDC_PWRSTS, m_pwrsts);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPemWinDlg, CDialog)
	//{{AFX_MSG_MAP(CPemWinDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_POWERON, OnPoweron)
	ON_BN_CLICKED(IDC_WINENABLE, OnWinenable)
	ON_BN_CLICKED(IDC_POWEROFF, OnPoweroff)
	ON_BN_CLICKED(IDC_WINDISABLE, OnWindisable)
	ON_BN_CLICKED(IDC_LEDGO, OnLedgo)
	ON_BN_CLICKED(IDC_NGLED, OnNgled)
	ON_BN_CLICKED(IDC_BEEP, OnBeep)
	ON_BN_CLICKED(IDC_LEDOFF, OnLedoff)
	ON_BN_CLICKED(IDC_BT_Pin42_output, OnBTPin42output)
	ON_BN_CLICKED(IDC_BT_Pin44_output, OnBTPin44output)
	ON_BN_CLICKED(IDC_BT_Pin46_output, OnBTPin46output)
	ON_BN_CLICKED(IDC_BT_Pin42_input, OnBTPin42input)
	ON_BN_CLICKED(IDC_BT_Pin44_input, OnBTPin44input)
	ON_BN_CLICKED(IDC_BT_Pin46_input, OnBTPin46input)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPemWinDlg message handlers

BOOL CPemWinDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	int status = pem.INIT();
	
	for (int i = 0; i < 4; i++)
	{
		pemvalid[i] = pem.VALIDPEM(i);
		if (pemvalid[i] == 1) 
		{
			// Find the current valid PEM Module
			currpemno = i;
		}
	}
	// Select PEM Module
	status = pem.SELPEM(currpemno);
	if (status != 0) AfxMessageBox("SELPEM Error!\n");

	//Current Calibrate


	status = pem.VALIDDEV();
	if (status == 1) 
	{
		// Device on Slot are Valid,
		// Same VID, DID
	}
	else 
	{
		AfxMessageBox("VALIDDEV Fail!  Need to Assign A New Device\n");
	}

	    m_nTimer = SetTimer(1, 5000, 0);

		

//*********************************************************
		status=pem.GPIOSETUP(1, 1, 0);  //Pin 42
		status=pem.GPIOSETUP(2, 1, 0);  //Pin 44
		status=pem.GPIOSETUP(3, 1, 0);  //Pin 46
//*********************************************************

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPemWinDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPemWinDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPemWinDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPemWinDlg::PostNcDestroy() 
{
	// TODO: Add your specialized code here and/or call the base class
	CDialog::PostNcDestroy();
}

void CPemWinDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	int status;
	double dval;
	UpdateData(TRUE);

	status = pem.GETPWRSTS();
	if (status == 1) 
	{
		m_pwrsts = "On";
	}
	else m_pwrsts = "Off";

	status = pem.GET3V3V(&dval);
	if (status == 0) 
	{
		m_3v3voltage = dval;
	}
	else m_3v3voltage = 0;

	status = pem.GET3V3I(&dval);
	if (status == 0) 
	{
		m_3v3current = dval;
	}
	else m_3v3current = 0;

	status = pem.GET1V5V(&dval);
	if (status == 0) 
	{
		m_1v5voltage = dval;
	}
	else m_1v5voltage = 0;

	status = pem.GET1V5I(&dval);
	if (status == 0) 
	{
		m_1v5current = dval;
	}
	else m_1v5current = 0;

	UpdateData(FALSE);

	CDialog::OnTimer(nIDEvent);
}

void CPemWinDlg::OnPoweron() 
{
	int status;
	status = pem.PON();
	if (status != 0) AfxMessageBox("Power On Fail!");
	UpdateData(TRUE);
	status = pem.GETPWRSTS();
	if (status == 0) 
	{
		m_pwrsts = "Off";
		// Short might happend,
		int vshort = pem.CHKSHORT();
		if (vshort & CPEMDLL_ERROR_3V3AUXSHORT) AfxMessageBox("3.3VAUX Rail Short!");
		if (vshort & CPEMDLL_ERROR_3V3SHORT) AfxMessageBox("3.3V Rail Short!");
		if (vshort & CPEMDLL_ERROR_1V5SHORT) AfxMessageBox("1.5V Rail Short!");		
	}
	else 
	{
		m_pwrsts = "Off";
		OnTimer(0);
	}

	UpdateData(FALSE);	
}

void CPemWinDlg::OnWinenable() 
{
	int status = pem.WINEN(200);
	if (status != 0) AfxMessageBox("Driver Enable Fail!");
}

void CPemWinDlg::OnPoweroff() 
{
	int status;
	status = pem.POFF();
	if (status != 0) AfxMessageBox("Power Off Fail!");	
	UpdateData(TRUE);
	status = pem.GETPWRSTS();
	if (status == 1) 
	{
		m_pwrsts = "On";
	}
	else m_pwrsts = "Off";

	OnTimer(0);

	UpdateData(FALSE);
}

void CPemWinDlg::OnWindisable() 
{
	int status = pem.WINDIS(200);
	if (status != 0) AfxMessageBox("Driver Disable Fail!");	
}

void CPemWinDlg::OnLedgo() 
{
	pem.LEDOFF();
	pem.LEDGO();

}

void CPemWinDlg::OnNgled() 
{
	pem.LEDOFF();
	pem.LEDNG();	
}

void CPemWinDlg::OnBeep() 
{
	pem.BEEP(2, 2);
}

void CPemWinDlg::OnLedoff() 
{
	pem.LEDOFF();	
}

void CPemWinDlg::OnBTPin42output() 
{
	int status;
	//*********************
	pem.GPIOSETUP(1, 1, 0);
    //*********************
	m_ED_42_Mode.SetWindowText("Output");
    if(Pin42_flag == true) 
	{
		//***********************
		status=pem.GPIOOUTSET(1);
		//***********************
		m_Pin42_output.SetWindowText("GPIO-1 Output (H)");
		m_ED_42_Value.SetWindowText("H");
	}
   	else 
	{
		//***********************
		status=pem.GPIOOUTRESET(1);
		//***********************
		m_Pin42_output.SetWindowText("GPIO-1 Output (L)");
		m_ED_42_Value.SetWindowText("L");
	}
	Pin42_flag=!Pin42_flag;
}

void CPemWinDlg::OnBTPin44output() 
{
	int status;
	//*********************
	pem.GPIOSETUP(2, 1, 0);
    //*********************
	m_ED_44_Mode.SetWindowText("Output");
	if(Pin44_flag == true) 
	{
		//***********************
		status=pem.GPIOOUTSET(2);
		//***********************
		m_Pin44_output.SetWindowText("GPIO-2 Output (H)");
		m_ED_44_Value.SetWindowText("H");
	}
   	else 
	{
		//***********************
		status=pem.GPIOOUTRESET(2);
		//***********************
		m_Pin44_output.SetWindowText("GPIO-2 Output (L)");
		m_ED_44_Value.SetWindowText("L");
	}
	Pin44_flag=!Pin44_flag;
}

void CPemWinDlg::OnBTPin46output() 
{
	int status;
	//*********************
	pem.GPIOSETUP(3, 1, 0);
    //*********************
	m_ED_46_Mode.SetWindowText("Output");
	if(Pin46_flag == true) 
	{
		status=pem.GPIOOUTSET(3);
		m_Pin46_output.SetWindowText("GPIO-3 Output (H)");
		m_ED_46_Value.SetWindowText("H");
	}
   	else 
	{
		status=pem.GPIOOUTRESET(3);
		m_Pin46_output.SetWindowText("GPIO-3 Output (L)");
		m_ED_46_Value.SetWindowText("L");
	}
	Pin46_flag=!Pin46_flag;	
}

void CPemWinDlg::OnBTPin42input() 
{
	int value=0, status=0;
	//*********************
	pem.GPIOSETUP(1, 0, 0);
    //*********************
	status=pem.GPIOGETSETUP(1);
	m_ED_42_Mode.SetWindowText("Input");
	value=pem.GPIOIN(1);
	if(value == 0) m_ED_42_Value.SetWindowText("L");
	else if(value == 1) m_ED_42_Value.SetWindowText("H");	
}

void CPemWinDlg::OnBTPin44input() 
{
	int value=0, status=0;
	//*********************
	pem.GPIOSETUP(2, 0, 0);
	//*********************
	status=pem.GPIOGETSETUP(2);
	m_ED_44_Mode.SetWindowText("Input");
	value=pem.GPIOIN(2);
	if(value == 0) m_ED_44_Value.SetWindowText("L");
	else if(value == 1) m_ED_44_Value.SetWindowText("H");
}

void CPemWinDlg::OnBTPin46input() 
{
	int value=0, status=0;
	int major, minor;
	//*********************
	pem.GPIOSETUP(3, 0, 0);
	//*********************
	status=pem.GPIOGETSETUP(3);
	m_ED_46_Mode.SetWindowText("Input");
	value=pem.GPIOIN(3);
	if(value == 0) m_ED_46_Value.SetWindowText("L");
	else if(value == 1) m_ED_46_Value.SetWindowText("H");
	pem.GETLIBVER(&major, &minor);
}

void CPemWinDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	KillTimer(m_nTimer);
	pem.EXIT();	
	
}
